from Tkinter import *
from Simulation import *
from visual import *

nSpinsX = 12
nSpinsY = 12

stripeSpacingX = 2
stripeSpacingY = 2

Ja = -1.0
Jbx = -1.0
Jby = -1.0

k = 2.0*pi*vector(1.0/nSpinsX,1.0/nSpinsY,0.0)

baseSigma = .1
dt = .001


tkr = Tk()
simu = Simulation(tkr, nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, Ja, Jbx, Jby, k, baseSigma, dt)




       

######-------------------------------------------------------######
###                             TKR                             ###
        
##  Instance creation ##
##tkr = Tk()
##simu = Simulation(tkr)

##  TKR appearance and widget creation ##

########
tkr.wm_geometry(newGeometry="400x450+700+20")   
tkr.wm_title("Controls")

########
topFrame = Frame(tkr,relief=SUNKEN, borderwidth=0)
topFrame.grid(row=0, column=0, padx=0, pady=0)


######
toggleFrame = Frame(topFrame, relief=FLAT, borderwidth=0)
toggleFrame.grid(row=0, column=0, padx=4, pady=4)

####
visualSphereFrame = Frame(toggleFrame, relief=FLAT, borderwidth=1)
visualSphereFrame.grid(row=0, column=0, padx=4, pady=4)

#
modesLabel = Label(visualSphereFrame, text="Visual Sphere Options:").grid(row=0, column=0, sticky=W)

tracersLabel = Label(visualSphereFrame, text="Tracers").grid(row=1, column=0, sticky=E)
tracersWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleTracersVar, command=simu.toggleTracers)
tracersWidget.grid(row=1, column=1)

pointsLabel = Label(visualSphereFrame, text="Points").grid(row=2, column=0, sticky=E)
pointsWidget = Checkbutton(visualSphereFrame, text="", variable=simu.togglePointsVar, command=simu.togglePoints)
pointsWidget.grid(row=2, column=1)

vectorsLabel = Label(visualSphereFrame, text="Vectors").grid(row=3, column=0, sticky=E)
vectorsWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleSphereVectorsVar, command=simu.toggleVectors)
vectorsWidget.grid(row=3, column=1)


axisDisplayLabel = Label(visualSphereFrame, text="Display Axis").grid(row=1, column=2, sticky=E)
axisDisplayWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleAxisVar, command=simu.toggleAxis)
axisDisplayWidget.grid(row=1, column=3)

axisSyncLabel = Label(visualSphereFrame, text="Sync View Axis").grid(row=2, column=2, sticky=E)
axisSyncWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleAxisSyncVar, command=simu.toggleAxisSync)
axisSyncWidget.grid(row=2, column=3)

UCvectorsLabel = Label(visualSphereFrame, text="UC Vectors").grid(row=3, column=2, sticky=E)
UCvectorsWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleUCVectorsVar, command=simu.toggleUCVectors)
UCvectorsWidget.grid(row=3, column=3)


phasePointsLabel = Label(visualSphereFrame, text="Phase Points").grid(row=1, column=4, sticky=E)
phasePointsWidget = Checkbutton(visualSphereFrame, text="", variable=simu.togglePhasePointsVar, command=simu.togglePhasePoints)
phasePointsWidget.grid(row=1, column=5)

anglePlotLabel = Label(visualSphereFrame, text="Angle Plot").grid(row=2, column=4, sticky=E)
anglePlotWidget = Checkbutton(visualSphereFrame, text="", variable=simu.toggleAnglePlotVar, command=simu.toggleAnglePlot)
anglePlotWidget.grid(row=2, column=5)
#


####
##visualSphereFrame = Frame(toggleFrame, relief=FLAT, borderwidth=1)
##visualSphereFrame.grid(row=0, column=0, padx=4, pady=4)

#
##visualsLabel = Label(visualSphereFrame, text="Visual Options:").grid(row=0, column=0, sticky=W)
##
##tracerWidget = Scale(visualSphereFrame, orient=VERTICAL, from_=256, to=0, resolution=1.0, label="Tracer Length", command=lambda str: simu.setTracerLength(str))
##tracerWidget.set(simu.tracerLength)
##tracerWidget.grid(row=0, column=1)

##sublatticesLabel = Label(visualSphereFrame, text="Sublattices").grid(row=1, column=0, sticky=E)
##sublatticesWidget = Checkbutton(visualSphereFrame, text="", variable=simu.tvSublattices, command=simu.tSublattices).grid(row=1, column=1)
##
##torqueLabel = Label(visualSphereFrame, text="Torques").grid(row=2, column=0, sticky=E)
##torqueWidget = Checkbutton(visualSphereFrame, text="", variable=simu.tv_torques, command=simu.t_torques).grid(row=2, column=1)
##
##colorLabel = Label(visualSphereFrame, text="Colors").grid(row=3, column=0, sticky=E)
##colorWidget = Checkbutton(visualSphereFrame, text="", variable=simu.tv_colors, command=simu.t_colors)
##colorWidget.grid(row=3, column=1)
##colorWidget.toggle()
##
##fmFilterLabel = Label(visualSphereFrame, text="FM Filter").grid(row=4, column=0, sticky=E)
##fmFilterWidget = Checkbutton(visualSphereFrame, text="", variable=simu.tvFmFilter, command=simu.tFmFilter).grid(row=4, column=1)
###



##
simuFrame = Frame(toggleFrame, relief=FLAT, borderwidth=0)
simuFrame.grid(row=1, column=0, columnspan=2, padx=4, pady=4)

#
simuLabel = Label(simuFrame, text="Simulation:").grid(row=0, column=0, sticky=W)
##
##stripesLabel = Label(simuFrame, text="Stripes").grid(row=1, column=0, sticky=E)
##stripesWidget = Checkbutton(simuFrame, text="", variable=simu.tvStripes, command=simu.tStripes).grid(row=1, column=1)
##
randomizeWidget = Button(simuFrame, text="Randomize", command=simu.randomize).grid(row=1, column=2, padx=4, pady=2)
resetWidget = Button(simuFrame, text="Reset", command=simu.reset).grid(row=1, column=3, padx=4, pady=2)




####
scalesFrame = Frame(topFrame, relief=FLAT, borderwidth=1)
scalesFrame.grid(row=1, column=0, columnspan=2, padx=10, pady=10)

#
scalesLabel = Label(scalesFrame, text="Scales:").grid(row=0, column=0, sticky=W)

kxWidget = Scale(scalesFrame, orient=VERTICAL, from_=2.01*3.14159, to=0.0, resolution=0.000001, label="kx", command=lambda str: simu.setKx(str))
kxWidget.set(simu.k.x)
kxWidget.grid(row=1, column=0)

kyWidget = Scale(scalesFrame, orient=VERTICAL, from_=2.01*3.14159, to=0.0, resolution=0.000001, label="ky", command=lambda str: simu.setKy(str))
kyWidget.set(simu.k.y)
kyWidget.grid(row=1, column=1)

JbxRatioWidget = Scale(scalesFrame, orient=VERTICAL, from_=10.0, to=-10.0, resolution=0.001, label="Jbx", command=lambda str: simu.setJbx(str))
JbxRatioWidget.set(simu.Jbx)
JbxRatioWidget.grid(row=1, column=2)

JbyRatioWidget = Scale(scalesFrame, orient=VERTICAL, from_=10.0, to=-10.0, resolution=0.001, label="Jby", command=lambda str: simu.setJby(str))
JbyRatioWidget.set(simu.Jby)
JbyRatioWidget.grid(row=1, column=3)
#


####
scales2Frame = Frame(topFrame, relief=FLAT, borderwidth=1)
scales2Frame.grid(row=2, column=0, columnspan=2, padx=10, pady=10)

#
meanFieldDownWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.001, label="MFD", command=lambda str: simu.setMFd(str))
meanFieldDownWidget.set(simu.MFd)
meanFieldDownWidget.grid(row=0, column=0)

meanFieldUpWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.001, label="MFU", command=lambda str: simu.setMFu(str))
meanFieldUpWidget.set(simu.MFu)
meanFieldUpWidget.grid(row=0, column=1)

tempWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.0, to=0, resolution=0.001, label="kT", command=lambda str: simu.setTemp(str))
tempWidget.set(simu.temp/simu.Ja)
tempWidget.grid(row=0, column=2)

DtWidget = Scale(scales2Frame, orient=VERTICAL, from_=simu.dtUpperLimit, to=0, label="dt", command=lambda str: simu.setDt(str))
DtWidget.set(simu.dt*1000000.0)
DtWidget.grid(row=0, column=3)
#


##  Enter the main TKR loop, starting the interface and program ##
tkr.mainloop()

